/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.storage;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarPlugin;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.ModuleUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.connected.StorageException;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.analysis.AnalysisContainer;
import org.sonarsource.sonarlint.core.container.analysis.DefaultAnalysisResult;
import org.sonarsource.sonarlint.core.container.global.DefaultRuleDetails;
import org.sonarsource.sonarlint.core.container.global.ExtensionInstaller;
import org.sonarsource.sonarlint.core.container.global.GlobalTempFolderProvider;
import org.sonarsource.sonarlint.core.container.storage.SonarQubeActiveRulesProvider;
import org.sonarsource.sonarlint.core.container.storage.SonarQubeRulesProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.container.storage.StoragePluginIndexProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageRulesProvider;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginJarExploder;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginRepository;
import org.sonarsource.sonarlint.core.plugin.PluginClassloaderFactory;
import org.sonarsource.sonarlint.core.plugin.PluginCopier;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginLoader;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCacheProvider;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.FileUtils;

public class StorageGlobalContainer
extends ComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(StorageGlobalContainer.class);

    public static StorageGlobalContainer create(ConnectedGlobalConfiguration globalConfig) {
        StorageGlobalContainer container = new StorageGlobalContainer();
        container.add(globalConfig);
        container.add(StorageManager.class);
        container.add(StoragePluginIndexProvider.class);
        return container;
    }

    @Override
    protected void doBeforeStart() {
        this.add(DefaultPluginRepository.class, PluginCopier.class, PluginLoader.class, PluginClassloaderFactory.class, DefaultPluginJarExploder.class, ExtensionInstaller.class, new GlobalTempFolderProvider(), UriReader.class, new PluginCacheProvider(), System2.INSTANCE);
    }

    @Override
    protected void doAfterStart() {
        GlobalUpdateStatus updateStatus = this.getUpdateStatus();
        if (updateStatus != null) {
            LOG.info("Using storage for server '{}' (last update {})", (Object)this.getComponentByType(ConnectedGlobalConfiguration.class).getServerId(), (Object)new SimpleDateFormat().format(updateStatus.getLastUpdateDate()));
            this.installPlugins();
        } else {
            LOG.warn("No storage for server '{}'. Please update.", (Object)this.getComponentByType(ConnectedGlobalConfiguration.class).getServerId());
        }
    }

    protected void installPlugins() {
        DefaultPluginRepository pluginRepository = this.getComponentByType(DefaultPluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            SonarPlugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, instance);
        }
    }

    public AnalysisResults analyze(ConnectedAnalysisConfiguration configuration, IssueListener issueListener) {
        ModuleUpdateStatus moduleUpdateStatus;
        GlobalUpdateStatus updateStatus = this.getUpdateStatus();
        if (updateStatus == null) {
            throw new StorageException("Missing global data. Please update server.", null);
        }
        if (configuration.moduleKey() != null && (moduleUpdateStatus = this.getModuleUpdateStatus(configuration.moduleKey())) == null) {
            throw new StorageException("Missing module data. Please update module '" + configuration.moduleKey() + "'.", null);
        }
        AnalysisContainer analysisContainer = new AnalysisContainer(this);
        analysisContainer.add(configuration);
        analysisContainer.add(issueListener);
        analysisContainer.add(new StorageRulesProvider());
        analysisContainer.add(new SonarQubeRulesProvider());
        analysisContainer.add(new SonarQubeActiveRulesProvider());
        DefaultAnalysisResult defaultAnalysisResult = new DefaultAnalysisResult();
        analysisContainer.add(defaultAnalysisResult);
        analysisContainer.execute();
        return defaultAnalysisResult;
    }

    public RuleDetails getRuleDetails(String ruleKeyStr) {
        Sonarlint.Rules rulesFromStorage = this.getComponentByType(StorageManager.class).readRulesFromStorage();
        RuleKey ruleKey = RuleKey.parse(ruleKeyStr);
        Sonarlint.Rules.Rule rule = rulesFromStorage.getRulesByKey().get(ruleKeyStr);
        if (rule == null) {
            throw new IllegalArgumentException("Unable to find rule with key " + ruleKey);
        }
        return new DefaultRuleDetails(ruleKeyStr, rule.getName(), rule.getHtmlDesc(), rule.getSeverity(), rule.getLang(), Collections.emptySet());
    }

    public GlobalUpdateStatus getUpdateStatus() {
        return this.getComponentByType(StorageManager.class).getGlobalUpdateStatus();
    }

    public ModuleUpdateStatus getModuleUpdateStatus(String moduleKey) {
        return this.getComponentByType(StorageManager.class).getModuleUpdateStatus(moduleKey);
    }

    public Map<String, RemoteModule> allModulesByKey() {
        HashMap<String, RemoteModule> results = new HashMap<String, RemoteModule>();
        Sonarlint.ModuleList readModuleListFromStorage = this.getComponentByType(StorageManager.class).readModuleListFromStorage();
        Map<String, Sonarlint.ModuleList.Module> modulesByKey = readModuleListFromStorage.getModulesByKey();
        for (Map.Entry<String, Sonarlint.ModuleList.Module> entry : modulesByKey.entrySet()) {
            results.put(entry.getKey(), new DefaultRemoteModule(entry.getValue()));
        }
        return results;
    }

    public void deleteStorage() {
        FileUtils.deleteDirectory(this.getComponentByType(StorageManager.class).getServerStorageRoot());
    }

    private static class DefaultRemoteModule
    implements RemoteModule {
        private final String key;
        private final String name;
        private final boolean root;

        public DefaultRemoteModule(Sonarlint.ModuleList.Module module) {
            this.key = module.getKey();
            this.name = module.getName();
            this.root = "TRK".equals(module.getQu());
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoot() {
            return this.root;
        }
    }
}

